/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.Calque;
import cds.aladin.ContourAlgorithm;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Ligne;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PlanTool;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.Properties;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Rectangle;

public final class PlanContour
extends PlanTool {
    static final String OutOfMemoryMESSAGE = "\n\n Either the image is too big \n or there are too many control points.\n Try to zoom in the part of the picture you are interested in \n(and select Consider current zoom only) \n and/or reduce the number of contour levels";
    static final int MAXLEVELS = 20;
    static final Color[] couleursBase = new Color[]{new Color(250, 51, 51), new Color(51, 51, 250), new Color(153, 51, 255), new Color(255, 51, 153), new Color(51, 153, 255), new Color(51, 255, 153)};
    static int icouleursBase = 0;
    boolean mustAdjustContour = false;
    double[] adjustTab = null;
    Calque calque;
    Plan p;
    boolean reduceNoise = true;
    boolean useOnlyCurrentZoom = false;
    private Ligne[][] lines;
    private double partDessin = 0.15;
    private int xShift = 0;
    private int yShift = 0;
    Rectangle zoomv;
    boolean useSmoothing = false;
    int smoothingLevel = 2;
    byte[] orgPixels;
    short[] pixels;
    int width = -1;
    int height = -1;
    int orgWidth = -1;
    int orgHeight = -1;
    int max;
    int min;
    private PlanImage pimg = null;
    private double[] levels = null;
    private double[] orgLevels = null;
    PointD[][] contours = null;
    Color[] couleursContours;
    protected ContourAlgorithm cAlgo = null;
    protected int nbLevels;
    private int nbLevelsComputed = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PlanContour(Aladin aladin, String label, PlanImage pimg, double[] levels, ContourAlgorithm cAlgo, boolean useSmoothing, int smoothingLevel, boolean useOnlyCurrentZoom, boolean reduceNoise, Color[] couleurs, Color cPlanContour) {
        this(aladin, label);
        this.hasXYorig = aladin.calque.getPlanRef() == null;
        this.askActive = false;
        this.flagOk = false;
        cAlgo.pc = this;
        this.pimg = pimg;
        this.levels = levels;
        this.orgLevels = (double[])this.levels.clone();
        this.nbLevels = levels.length;
        this.cAlgo = cAlgo;
        this.useSmoothing = useSmoothing;
        this.smoothingLevel = smoothingLevel;
        this.useOnlyCurrentZoom = useOnlyCurrentZoom;
        this.reduceNoise = reduceNoise;
        this.initCouleurs(couleurs);
        this.c = cPlanContour;
        PlanContour planContour = this;
        synchronized (planContour) {
            this.runme = new Thread((Runnable)this, "AladinContour");
            Util.decreasePriority(Thread.currentThread(), this.runme);
            this.runme.start();
        }
    }

    protected PlanContour(Aladin aladin, String label) {
        super(aladin, label);
        this.calque = aladin.calque;
        this.setPourcent(-1.0);
    }

    protected PlanContour(Aladin aladin) {
        this(aladin, "");
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public boolean isMovable() {
        return false;
    }

    @Override
    protected boolean waitForPlan() {
        try {
            this.setPourcent(-1.0);
            if (this.mustAdjustContour) {
                for (int i = 0; i < this.orgLevels.length; ++i) {
                    if (this.adjustTab[i] == this.orgLevels[i]) continue;
                    this.doAdjustContour(this.adjustTab[i], i);
                }
                this.mustAdjustContour = false;
                this.adjustTab = null;
                return true;
            }
            while (!this.calque.zoom.zoomView.zoomok) {
                Util.pause(10);
            }
            this.zoomv = this.aladin.calque.zoom.getZoom();
            this.setPourcent(0.0);
            if (!this.getAllContours()) {
                Aladin.error(Aladin.error + OutOfMemoryMESSAGE);
                return false;
            }
            this.drawAllContours();
            this.setPourcent(-1.0);
            return true;
        }
        catch (OutOfMemoryError e) {
            Aladin.error = e.toString();
            Aladin.error(e + OutOfMemoryMESSAGE);
            return false;
        }
        catch (Exception exc) {
            Aladin.error = exc.toString();
            Aladin.error(Aladin.error);
            return false;
        }
    }

    protected boolean getPixels() {
        Plan plan = this.p = this.pimg == null ? this.calque.getPlanBase() : this.pimg;
        if (this.p == null) {
            return false;
        }
        this.objet = this.p.objet;
        this.body = this.p.body;
        this.orgWidth = ((PlanImage)this.p).width;
        this.orgHeight = ((PlanImage)this.p).height;
        this.zoomv.x = this.zoomv.x > 0 ? this.zoomv.x : 0;
        this.zoomv.y = this.zoomv.y > 0 ? this.zoomv.y : 0;
        this.zoomv.width = this.zoomv.width > this.orgWidth ? this.orgWidth : this.zoomv.width;
        int n = this.zoomv.height = this.zoomv.height > this.orgHeight ? this.orgHeight : this.zoomv.height;
        if (this.zoomv.x + this.zoomv.width > this.orgWidth) {
            this.zoomv.width = this.orgWidth - this.zoomv.x;
        }
        if (this.zoomv.y + this.zoomv.height > this.orgHeight) {
            this.zoomv.height = this.orgHeight - this.zoomv.y;
        }
        try {
            this.orgPixels = ((PlanImage)this.p).getBufPixels8();
            short[] data = new short[this.orgPixels.length];
            for (int i = data.length - 1; i >= 0; --i) {
                data[i] = (short)(this.orgPixels[i] < 0 ? 256 + this.orgPixels[i] : this.orgPixels[i]);
            }
            if (this.useOnlyCurrentZoom) {
                this.width = this.zoomv.width;
                this.height = this.zoomv.height;
                if (this.useSmoothing) {
                    this.width /= this.smoothingLevel;
                    this.height /= this.smoothingLevel;
                    this.pixels = new short[this.width * this.height];
                    this.makeSmoothing(data, this.pixels, this.width, this.height, this.orgWidth, this.orgHeight, this.zoomv.x, this.zoomv.y, this.smoothingLevel);
                } else {
                    this.pixels = new short[this.width * this.height];
                    for (int y = this.height - 1; y >= 0; --y) {
                        for (int x = this.width - 1; x >= 0; --x) {
                            this.pixels[y * this.width + x] = data[y * this.orgWidth + x + this.zoomv.x + this.orgWidth * this.zoomv.y];
                        }
                    }
                }
            } else {
                this.width = this.orgWidth;
                this.height = this.orgHeight;
                if (this.useSmoothing) {
                    this.width /= this.smoothingLevel;
                    this.height /= this.smoothingLevel;
                    this.pixels = new short[this.width * this.height];
                    this.makeSmoothing(data, this.pixels, this.width, this.height, this.orgWidth, this.orgHeight, 0, 0, this.smoothingLevel);
                } else {
                    this.pixels = new short[this.width * this.height];
                    this.pixels = data;
                }
            }
            if (this.reduceNoise) {
                this.pixels = this.moyenne(this.pixels, this.width, this.height);
                --this.width;
                --this.height;
            }
        }
        catch (OutOfMemoryError e) {
            Aladin.error = e.toString();
            this.aladin.gc();
            return false;
        }
        catch (Exception exc) {
            Aladin.error = exc.toString();
            return false;
        }
        this.p.sendLog("Contour", "[" + this.p.getLogInfo() + "]");
        return true;
    }

    protected boolean getAllContours() {
        this.contours = new PointD[this.levels.length][];
        if (!this.getPixels()) {
            return false;
        }
        this.adjustLevels();
        this.cAlgo.setData(this.pixels);
        this.cAlgo.setDimension(this.width, this.height);
        try {
            for (int indiceLevel = 0; indiceLevel < this.levels.length; ++indiceLevel) {
                PointD[] contourCourant = this.getContour(this.levels[indiceLevel]);
                this.contours[indiceLevel] = contourCourant;
                ++this.nbLevelsComputed;
            }
        }
        catch (OutOfMemoryError e) {
            Aladin.error = e.toString();
            return false;
        }
        return true;
    }

    private void adjustLevels() {
        if (this.useSmoothing) {
            for (int i = 0; i < this.orgLevels.length; ++i) {
                this.levels[i] = (double)(this.smoothingLevel * this.smoothingLevel) * this.orgLevels[i];
            }
        }
    }

    private PointD[] getContour(double level) {
        this.cAlgo.setLevel(level);
        return this.cAlgo.getContours();
    }

    protected void drawContour(int indLevel) {
        int nbPoints = 0;
        ViewSimple v = this.aladin.view.getCurrentView();
        Plan base = v.pref;
        Projection projv = v.getProj();
        if (base == null) {
            base = this;
        }
        int coeff = 1;
        if (this.useSmoothing) {
            coeff = this.smoothingLevel;
        }
        if (this.useOnlyCurrentZoom) {
            this.xShift += this.zoomv.x;
            this.yShift += this.zoomv.y;
        }
        if (this.useSmoothing) {
            if (this.reduceNoise) {
                this.xShift += this.smoothingLevel;
                this.yShift += this.smoothingLevel;
            } else {
                this.xShift += this.smoothingLevel / 2 + this.smoothingLevel % 2;
                this.yShift += this.smoothingLevel / 2 + this.smoothingLevel % 2;
            }
        } else if (this.reduceNoise) {
            ++this.xShift;
            ++this.yShift;
        }
        PointD[] cont = this.contours[indLevel];
        Ligne[] curLevLines = new Ligne[cont.length];
        int i = 0;
        Coord c = new Coord();
        while (i < cont.length - 1) {
            PointD pointj;
            PointD point0;
            if ((point0 = cont[++i]) == null) continue;
            c.x = (double)coeff * point0.x + (double)this.xShift;
            c.y = (double)coeff * point0.y + (double)this.yShift;
            double x1 = c.x;
            double y1 = c.y;
            if (this.p.projd != projv) {
                c.x = v.HItoI(c.x);
                c.y = v.HItoI(c.y);
                this.p.projd.getCoord(c);
                projv.getXY(c);
                x1 = v.ItoHI(c.x);
                y1 = v.ItoHI(c.y);
            }
            Ligne ligne0 = new Ligne((Plan)this, v, v.HItoI(x1), v.HItoI(y1), this.couleursContours[indLevel]);
            this.pcat.setObjet(ligne0);
            curLevLines[nbPoints] = ligne0;
            ++nbPoints;
            int j = 1;
            while (i + j < cont.length && (pointj = cont[i + j]) != null) {
                c.x = (double)coeff * pointj.x + (double)this.xShift;
                c.y = (double)coeff * pointj.y + (double)this.yShift;
                x1 = c.x;
                y1 = c.y;
                if (this.p.projd != projv) {
                    c.x = v.HItoI(c.x);
                    c.y = v.HItoI(c.y);
                    this.p.projd.getCoord(c);
                    projv.getXY(c);
                    x1 = v.ItoHI(c.x);
                    y1 = v.ItoHI(c.y);
                }
                Ligne lignej = new Ligne((Plan)this, v, v.HItoI(x1), v.HItoI(y1), ligne0, this.couleursContours[indLevel]);
                this.pcat.setObjet(lignej);
                curLevLines[nbPoints] = lignej;
                ++nbPoints;
                ligne0 = lignej;
                ++j;
            }
            i += j;
        }
        Ligne[] tmp = new Ligne[nbPoints];
        System.arraycopy(curLevLines, 0, tmp, 0, nbPoints);
        this.lines[indLevel] = tmp;
        this.xShift = 0;
        this.yShift = 0;
    }

    protected void drawAllContours() {
        if (this.couleursContours == null) {
            this.couleursContours = new Color[this.levels.length];
            Color[] base = Couleur.getBrighterColors(this.c, 4);
            for (int i = 0; i < this.couleursContours.length; ++i) {
                this.couleursContours[i] = base[i % base.length];
            }
        }
        this.lines = new Ligne[this.levels.length][];
        for (int i = 0; i < this.levels.length; ++i) {
            this.drawContour(i);
        }
        this.calque.repaint();
    }

    @Override
    protected boolean isSync() {
        return this.flagOk && (this.error != null || !this.mustAdjustContour);
    }

    @Override
    protected boolean Free() {
        this.pixels = null;
        this.orgPixels = null;
        this.couleursContours = null;
        this.adjustTab = null;
        this.levels = null;
        this.orgLevels = null;
        this.contours = null;
        this.lines = null;
        this.zoomv = null;
        this.p = null;
        this.pimg = null;
        this.cAlgo = null;
        return super.Free();
    }

    protected void useSmoothing(boolean b) {
        this.useSmoothing = b;
    }

    protected boolean isViewable(int indice) {
        if (this.lines == null) {
            return true;
        }
        Ligne[] lignes = this.lines[indice];
        if (lignes.length != 0) {
            Ligne l = lignes[0];
            return !l.hidden;
        }
        return true;
    }

    protected void setViewable(int indLevel, boolean value) {
        if (this.lines == null) {
            return;
        }
        Ligne[] lignesATraiter = this.lines[indLevel];
        for (int i = 0; i < lignesATraiter.length; ++i) {
            Ligne l = lignesATraiter[i];
            l.hidden = !value;
        }
    }

    @Override
    protected void setPropertie(String prop, String specif, String value) throws Exception {
        if (prop.equalsIgnoreCase("Color")) {
            Color color = Action.getColor(value);
            if (color == null) {
                throw new Exception("Syntax error in color function (ex: rgb(30,60,255) )");
            }
            this.updateColorIfNeeded(color);
            Properties.majProp(this);
            this.aladin.calque.repaintAll();
        } else {
            super.setPropertie(prop, specif, value);
        }
    }

    protected void updateColorIfNeeded(Color newColor) {
        if (newColor != null && !newColor.equals(this.c)) {
            this.c = newColor;
            Color[] base = Couleur.getBrighterColors(this.c, 4);
            for (int i = 0; i < this.nbLevels; ++i) {
                this.adjustColor(new Color(base[i % base.length].getRGB()), i);
            }
        }
    }

    protected void adjustColor(Color c, int indice) {
        if (!this.couleursContours[indice].equals(c)) {
            this.couleursContours[indice] = new Color(c.getRGB());
            Ligne[] lignesATraiter = this.lines[indice];
            for (int i = 0; i < lignesATraiter.length; ++i) {
                Ligne l = lignesATraiter[i];
                l.couleur = new Color(c.getRGB());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustContour(double[] tab) {
        this.adjustTab = tab;
        this.mustAdjustContour = true;
        PlanContour planContour = this;
        synchronized (planContour) {
            this.runme = new Thread((Runnable)this, "AladinContourAdjust"){};
            Util.decreasePriority(Thread.currentThread(), this.runme);
            this.runme.start();
        }
    }

    protected void updatePourcent(double p) {
        if (this.mustAdjustContour) {
            return;
        }
        this.setPourcent((1.0 - this.partDessin) * 100.0 * (((double)this.nbLevelsComputed + p) / (double)this.orgLevels.length));
    }

    protected static Color getNextColor(Calque calque) {
        int j;
        for (j = 0; j < couleursBase.length; ++j) {
            int i;
            for (i = 0; i < calque.plan.length && (calque.plan[i].type == 0 || couleursBase[j] != calque.plan[i].c); ++i) {
            }
            if (i == calque.plan.length) break;
        }
        if (j == couleursBase.length) {
            if (++icouleursBase == couleursBase.length) {
                icouleursBase = 0;
            }
            j = icouleursBase;
        }
        return couleursBase[j];
    }

    protected int[] getIntLevels() {
        int[] levels = new int[this.orgLevels.length];
        for (int i = 0; i < this.orgLevels.length; ++i) {
            levels[i] = this.adjustTab != null ? (int)this.adjustTab[i] : (int)this.orgLevels[i];
        }
        return levels;
    }

    private synchronized void doAdjustContour(double level, int indice) {
        Aladin.trace(3, "Level adjusted for index " + indice);
        this.mustAdjustContour = true;
        this.orgLevels[indice] = level;
        this.levels[indice] = level;
        this.adjustLevels();
        PointD[] contourCourant = this.getContour(this.levels[indice]);
        this.contours[indice] = contourCourant;
        Ligne[] linesToDel = this.lines[indice];
        boolean viewable = true;
        for (int i = 0; i < linesToDel.length; ++i) {
            Ligne l = linesToDel[i];
            if (i == 0) {
                viewable = !l.hidden;
            }
            this.pcat.delObjet(l);
        }
        this.drawContour(indice);
        this.setViewable(indice, viewable);
        this.calque.repaintAll();
    }

    private void initCouleurs(Color[] couleurs) {
        if (couleurs != null) {
            this.couleursContours = new Color[this.orgLevels.length];
            for (int i = 0; i < this.couleursContours.length; ++i) {
                this.couleursContours[i] = couleurs[i];
            }
        } else {
            this.couleursContours = null;
        }
    }

    private void makeSmoothing(short[] data, short[] pix, int width, int height, int orgWidth, int orgHeight, int decalX, int decalY, int smoothLevel) {
        int nbPixels = smoothLevel * smoothLevel;
        int[] pos = new int[nbPixels];
        int[] p = new int[nbPixels];
        for (int y = height - 1; y >= 0; --y) {
            int a = y * width;
            for (int x = width - 1; x >= 0; --x) {
                int i;
                int b = smoothLevel * y * orgWidth + smoothLevel * x + decalX + decalY * orgWidth;
                for (i = smoothLevel - 1; i >= 0; --i) {
                    pos[i] = b + i;
                    p[i] = data[pos[i]];
                    for (int j = smoothLevel - 1; j >= 1; --j) {
                        int factor = j * smoothLevel;
                        pos[i + factor] = pos[i] + j * orgWidth;
                        p[i + factor] = data[pos[i + factor]];
                    }
                }
                int somme = 0;
                for (i = nbPixels - 1; i >= 0; --i) {
                    somme += p[i];
                }
                pix[a + x] = (short)somme;
            }
        }
    }

    private short[] moyenne(short[] pix, int width, int height) {
        short[] result = new short[(width - 1) * (height - 1)];
        for (int j = height - 2; j >= 0; --j) {
            int a = j * width;
            for (int i = width - 2; i >= 0; --i) {
                short p1 = pix[a + i];
                short p2 = pix[a + i + 1];
                short p3 = pix[a + i + width];
                short p4 = pix[a + i + width + 1];
                result[j * (width - 1) + i] = (short)((p1 + p2 + p3 + p4) / 4);
            }
        }
        return result;
    }
}

